﻿#include "precompiled.h"
#include "common.h"
#include "Shader.h"

#include "RendererDefines.h"
#include <d3dcompiler.h>

using namespace DirectX;

// Includes to use if I decide to add async compilation/loading
//#include <ppl.h>
//#include <ppltasks.h>

namespace RTCam {

Shader::Shader()
{
}

Shader::~Shader()
{
}

ComPtr<ID3DBlob> Shader::LoadShader(_In_z_ const char* fileName, _In_z_ const char* entryPoint, _In_z_ const char* shaderModel)
{
	ComPtr<ID3DBlob> outputBlob;
	wstring rootPath = GetExePath() + L"Shaders\\";

#if !defined(COMPILE_SHADERS)
	wstring fullname = rootPath + Utf8ToUtf16(fileName) + L".cso";
	ThrowIfFailed(
		D3DReadFileToBlob(fullname.c_str(), &outputBlob)
		);
#else

	DWORD dwShaderFlags = D3DCOMPILE_ENABLE_STRICTNESS;

	#if defined( DEBUG ) || defined( _DEBUG )
		// Set the D3DCOMPILE_DEBUG flag to embed debug information in the shaders.
		// Setting this flag improves the shader debugging experience, but still allows 
		// the shaders to be optimized and to run exactly the way they will run in 
		// the release configuration of this program.
		dwShaderFlags |= D3DCOMPILE_DEBUG;
	#endif

	ComPtr<ID3DBlob> errorBlob;

	wstring fullname = rootPath + Utf8ToUtf16(fileName) + L".hlsl";
	HRESULT hr = D3DCompileFromFile(
		fullname.c_str(),
		nullptr,
		D3D_COMPILE_STANDARD_FILE_INCLUDE,
		entryPoint,
		shaderModel, 
		dwShaderFlags,
		0,
		&outputBlob,
		&errorBlob
		);

	if(FAILED(hr))
	{
		if(errorBlob != NULL) {
			wstring errorMsg = Utf8ToUtf16(static_cast<char*>(errorBlob->GetBufferPointer()));
			ShowMessageBox(errorMsg.c_str(), L"Shader compilation failed");
		}
		BreakAndThrow(GetErrorMessage(hr).c_str());
	}
#endif

	ASSERT(outputBlob != nullptr);
	return outputBlob;
}

} // end namespace